//
//  RMXPath.h
//  RMFoundation
//
//  Created by Keith Duncan on 25/01/2012.
//  Copyright (c) 2012 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSArray *RMFoundationXPathTokenise(NSString *XPath, NSError **errorRef);
extern NSString *RMFoundationXPathSerialise(NSArray *tokens);

/*!
	\brief
	This function converts an XPath with namespaces into an XPath suitable for use with the NSXML family of classes
	
	\details
	Given the following semantically equivalent documents, though differing in syntax:
	
	@@@
	<?xml version="1.0" encoding="utf-8"?>
	<root xmlns="http://realmacsoftware.com/namespaces/example.xml">
		<child>
			<grandchild/>
		</child>
		<child/>
		<child/>
	</root>
	@@@
 
	@@@
	<?xml version="1.0" encoding="utf-8"?>
	<root xmlns:name="http://realmacsoftware.com/namespaces/example.xml">
		<name:child>
			<name:grandchild/>
		</name:child>
		<name:child/>
		<name:child/>
	</root>
	@@@
	
	@@@
	doc1 = NSXMLDocument.alloc.initWithXMLString_options_error "<?xml version=\"1.0\" encoding=\"utf-8\"?><root xmlns=\"http://realmacsoftware.com/namespaces/example.xml\"><child><grandchild/></child><child/><child/></root>", 0
	doc2 = NSXMLDocument.alloc.initWithXMLString_options_error "<?xml version=\"1.0\" encoding=\"utf-8\"?><root xmlns:name=\"http://realmacsoftware.com/namespaces/example.xml\"><name:child><name:grandchild/></name:child><name:child/><name:child/></root>", 0
	@@@
	
	`[xmlDocument nodesForXPath:@"/root/child/grandchild" error:NULL]` will return a populated array for the first document, and an empty array for the second document
	`[xmlDocument nodesForXPath:RMXMLPreprocessXPath(@"/root/name:child/name:grandchild", @{ @"name" : @"http://realmacsoftware.com/namespaces/example.xml" }) error:NULL]` will return a populated array for both documents
	
	\param namespacesMap
	Map of prefix string to URI string
	
	\return
	An XPath where QName references of the form `a:root` given a namespacesMap of the form `{ @"a" : @"http://realmacsoftware.com/namespaces/example.xml" }` are transformed into `*[local-name() = 'a' and string(namespace-uri()) = 'http://realmacsoftware.com/namespaces/example.xml']` which is equivalent to the orignal QName
 */
extern NSString *RMFoundationXPathPreprocess(NSString *XPathWithNamespaces, NSDictionary *namespacesMap);
